<?php
/**
 * Created by PhpStorm.
 * User: Administrador
 * Date: 23/01/2018
 * Time: 02:06 PM.
 */

namespace App\Controller\v1;

use App\Service\DocumentRequestInterface;
use Greenter\Model\Sale\Invoice;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Greenter\Model\Response\StatusCdrResult;
use Symfony\Component\HttpFoundation\JsonResponse;
use Greenter\Model\Response\BillResult;
/**
 * Class InvoiceController.
 *
 * @Route("/api/v1/invoice")
 */
class InvoiceController extends AbstractController
{
    /**
     * @var DocumentRequestInterface
     */
    private $document;

    /**
     * InvoiceController constructor.
     * @param DocumentRequestInterface $document
     */
    public function __construct(DocumentRequestInterface $document)
    {
        $this->document = $document;
        $this->document->setDocumentType(Invoice::class);
    }

    /**
     * @Route("/send", methods={"POST"})
     *
     * @return Response
     */
    public function send(): Response
    {
        return $this->document->send();
    }

    /**
     * @Route("/xml", methods={"POST"})
     *
     * @return Response
     */
    public function xml(): Response
    {
        return $this->document->xml();
    }

    /**
     * @Route("/pdf", methods={"POST"})
     *
     * @return Response
     */
    public function pdf(): Response
    {
        return $this->document->pdf();
    }

    /**
     * @Route("/cdr", methods={"POST"})
     *
     * @param Request $request
     * @return Response
     */
    public function cdr(Request $request): Response
    {
        $ruc = $request->query->get('ruc');
        $tipo = $request->query->get('tipo');
        $serie = $request->query->get('serie');
        $numero = $request->query->get('numero');
 $statusCdrResult = $this->document->cdr($ruc, $tipo, $serie, $numero);

        if ($statusCdrResult instanceof StatusCdrResult) {

            $data = [
                'codigo' => $statusCdrResult->getCode(),
                'descripcion' => $statusCdrResult->getMessage(),
                'cdrData' =>'as'
            ];
            if ($statusCdrResult->getCdrZip()) {
                $arguments = [
                    $ruc,
                    $tipo,
                    $serie,
                    intval($numero)
                ];
                $filename = 'R-'.implode('-', $arguments).'.zip';
                $fileDir = '/var/www/html/cdr';

                if (!file_exists($fileDir)) {
                    mkdir($fileDir, 0777, true);
                }
                $pathZip = $fileDir.DIRECTORY_SEPARATOR.$filename;
                file_put_contents($pathZip, $statusCdrResult->getCdrZip());
                $cdrBase64 = base64_encode(file_get_contents($pathZip));
                $data = [
                    'codigo' => $statusCdrResult->getCode(),
                    'descripcion' => $statusCdrResult->getMessage(),
                    'cdrData' =>$cdrBase64
                ];
            }
            return new JsonResponse($data);
        } else {
            return new JsonResponse(['message' => 'Error obteniendo el CDR'], 500);
        }
    }

}
